<?php
/**
* @package css2switch
* @author Dominik Gorczyca - mediahof
* 
* --------------------------------------------------------------------------------
* All rights reserved.  css2switch Component for Joomla! 1.5
*
**/
defined( '_JEXEC' ) or die( 'Restricted access' );

class css2switch
{
	var $sortArray		= array();
	var $menuTypArray	= array();
	var	$publishColor	= array( 0 => 'ff5555', 1 => '000000');

	/**
	 * Ldt alle Menutypen mit Namen aus der Datenbank und speichert in ein Array $menuTypArray
	 *
	 */
	function ladeMenutypen()
	{
		$mTyp = $this->tabelleAuslesen('menu_types');
		for ($a = 0; $a < count($mTyp); $a++ )
		{
			$this->menuTypArray = array_merge( $this->menuTypArray, array($mTyp[$a]->menutype => $mTyp[$a]->title) );
			$this->menuArray[] = $mTyp[$a]->menutype;
		}
	}

	/**
	 * Dateien von bestimmten Typ aus ausgewhlten Verzeichnis auslesen,
	 * entwieder als Array zurckliefern oder in Klassen-Array speichern.
	 * Der erste Parameter muss angegeben werden, die anderen sind optional
	 * 
	 * $path	- Verzeichnis der gelesen wird
	 * Ist $return = 1 werden Dateinamen als Array zurckgeliefert
	 * Ist $return = 0 werden Dateinamen in ein Array mit dem Namen der $array-Variable gespeichert
	 * $array	- Name vom Klassen-Array
	 * $prefix	- Nur Dateiennamen die mit $prefix anfangen werden gelesen
	 * $typ		- Nur Dateiennamen die mit $typ enden werden gelesen
	 * 
	 * @param string $path
	 * @param int $return
	 * @param string $array
	 * @param string $prefix
	 * @param string $typ
	 * @return class-array
	 */
	function leseTempVerzeichnis($path, $array, $prefix = 'temp', $typ = '.css')
	{
		$dp = JFolder::files($path);
		foreach ($dp as $dir)
		{
			if (substr(strtolower($dir), -strlen($typ), strlen($typ)) == $typ && substr(strtolower($dir), 0, strlen($prefix)) == $prefix)
			{
				$this->{$array}[] = $dir;
			}
		}
	}

	/**
	 * Hauptmenupunkt anhang der ID ermitteln
	 *
	 * @param int $id
	 * @return int
	 */
	function testParentId($id)
	{
		$pid = $this->tabelleAuslesen('css2switch_items', 'items = '.$id.' AND parentid = 0');
		is_object($pid) ? $return = $pid->parentid : $return = '';
		return $return;
	}

	/**
	 * assoziatives Array sortieren nach $id
	 *
	 * @param array $array
	 * @param int $id
	 * @return array
	 */
	function arraySort($array, $id)
	{
		$temp_array = array();
		while(count($array) > 0)
		{
			$lowest_id = 0;
			$index = 0;
			foreach ($array as $item)
			{
				if ($item[$id] < $array[$lowest_id][$id])
				{
					$lowest_id = $index;
				}
				$index++;
			}
			$temp_array[] = $array[$lowest_id];
			$array = array_merge(array_slice($array, 0,$lowest_id), array_slice($array, $lowest_id+1));
		}
		return $temp_array;
	}

	/**
	 * Ganze Tabelle aus der Datenabnk auslesen
	 *
	 * @return Object
	 */
	function tabelleAuslesen($tabelle, $where = '')
	{
		$db =& JFactory::getDBO();
		!empty($where) ? $tabelle = $tabelle.' WHERE '.$where : '';
		$db->setQuery('SELECT * FROM #__'.$tabelle);
		empty($where) ? $return = $db->loadObjectList() : $return = $db->loadObject();
		return $return;
	}

	/**
	 * Leert eine Tablle in der Datenbank
	 *
	 * @param string $tName
	 */
	function tabelleLeeren($tName)
	{
		$db =& JFactory::getDBO();
		$db->setQuery('DELETE FROM #__'.$tName);
		$db->query();
	}

	/**
	 * Fgt inhalt in eine Tabelle ein
	 *
	 * @param string $tabelle
	 * @param string $inhalt
	 */
	function inhaltSpeichern($tabelle, $inhalt)
	{
		$db =& JFactory::getDBO();
		$db->setQuery("INSERT INTO #__".$tabelle." SET ".$inhalt);
		$db->query();
	}

}

?>
