<?php
/**
 * IDEALIAGroup srl
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@idealiagroup.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this module to newer
 * versions in the future.
 *
 * @category   IG
 * @package    IG_CashOnDelivery
 * @copyright  Copyright (c) 2010-2011 IDEALIAGroup srl (http://www.idealiagroup.com)
 * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * @author     Riccardo Tempesta <tempesta@idealiagroup.com>
*/
 
class FandM_VisitateBarcodes_Model_Ticket extends Mage_Core_Model_Abstract
{
	
	protected $_item = null;
	protected $_options = null;
	
	public function _construct() {
		parent::_construct();
		$this->_init('visitatebarcodes/ticket');
	}
	
	/**
	 * @return Mage_Sales_Model_Order_Invoice_Item
	 */
	public function getInvoiceItem() {
		if (is_null($this->_item)) {
			/* @var $invoice Mage_Sales_Model_Order_Invoice */
			$invoice = Mage::getSingleton("sales/order_invoice");
			$invoice->load($this->getData("invoice_id"));
			$this->_item = $invoice->getItemById($this->getData("invoice_item_id"));
		}
		Mage::log('Get Invoice ('. $this->getData("invoice_id").'):');//.print_r($this->_item,true));
		return $this->_item;
	}
	
	private function getItemOptions() {
		if (is_null($this->_options)) {
			if (isset($this->getInvoiceItem()->getOrderItem()->_data['product_options'])) {
				$this->_options = unserialize($this->getInvoiceItem()->getOrderItem()->_data["product_options"]);
			} else {
				$this->_options = false;
			}
		}
		return $this->_options;
	}

	public function getAWFromDate() {
		$options = $this->getItemOptions();
		Mage::log(print_r($options,true));
		if (isset($options["info_buyRequest"]["aw_booking_from"])) {
			return $options["info_buyRequest"]["aw_booking_from"];
		}
		return false;
		
		//$from_date = explode(".", $var["info_buyRequest"]["aw_booking_from"]);
        //$from_date = $from_date[2]."-".$from_date[1]."-".$from_date[0];
        //return $from_date;
	}
	
	public function getAWTimeFrom() {
		$options = $this->getItemOptions();
		if (isset($options["info_buyRequest"]["aw_booking_time_from"]["hours"])) {
        	return $options["info_buyRequest"]["aw_booking_time_from"]["hours"] . ":" .
        		   $options["info_buyRequest"]["aw_booking_time_from"]["minutes"]; 
		}
		return false;
	}
	
	public function getAWTimeTo() {
		$options = $this->getItemOptions();
		if (isset($options["info_buyRequest"]["aw_booking_time_to"]["hours"])) {
        	return $options["info_buyRequest"]["aw_booking_time_to"]["hours"] . ":" . 
        		   $options["info_buyRequest"]["aw_booking_time_to"]["minutes"];
		}
		return false;
	}
	
	
}
