<?php

class FandM_VisitateBarcodes_Model_Observer
{
    public function __construct() {
    }
    
    /**
     * 
     * @param Varien_Event_Observer $observer
     */
    public function make_invoice($observer) {
    	if (Mage::getStoreConfig('fandm/visitatebarcodes/enabled')) {
	    	$event = $observer->getEvent();
	    	$invoice = $event->getInvoice();
	    		foreach($invoice->getAllItems() as $item) {
	    			// @var $item Mage_Sales_Model_Order_Invoice_Item 
	    			if ($item->getSku() != Mage::getStoreConfig( "fandm/mandatoryitems/default_sku")
	                	&& $item->getSku() != Mage::getStoreConfig("fandm/mandatoryitems/sku1")) {
	                	$customer_id = Mage::getStoreConfig('fandm/visitatebarcodes/customer_id');
	                	Mage::log('CustomerID:'.$customer_id);
	                	for ($i = 0; $i < $item->getQty(); $i++) {
	                		$article_id = str_replace("-", "", $item->getSku());
	                		/* @var $ticket FandM_VisitateBarcodes_Model_Ticket */
	    					$ticket = Mage::getModel('visitatebarcodes/ticket');
			    			$ticket->setData("invoice_id", $invoice->getId());
					    	$ticket->setData("invoice_item_id", $item->getId());
					    	$ticket->setData("invoice_item_counter", $i);
					    	$ticket->setData("customer_id", $invoice->getOrder()->getData("customer_id", 0));
					    	$ticket->setData("article_id", $article_id);
							$ticket->setData("price", $item->getPrice());
							Mage::log('entrance_TS:' . $ticket->getAWFromDate());
							$entrance_date = new Zend_Date($ticket->getAWFromDate() . " 20:00:00",'dd.MM.yy hh:m:ss', 'de_DE');
							$ticket->setData("entrance_ts", $entrance_date->toString('Y-MM-dd HH:mm:ss'));
							Mage::log('entrance ZendDate:'. $entrance_date->toString('Y-MM-dd HH:mm:ss'));
					       	$ticket->save();
					    	
	        				$ticket->setData("ticket_number", 
					    		"000".
					    		$this->zero_fill($customer_id, 3).
					    		$this->zero_fill($article_id, 7).
					    		$this->zero_fill($ticket->getData("id", 0), 7));
					    	$ticket->save();
	                	}
	               	}
	    		}
				Mage::log('Before Invoice sent');
	  			$invoice->sendEmail(true, '');
	  			Mage::log('After Invoice was sent');
	            $invoice->setEmailSent(true);	    		
	        }		
    	return $observer; 
    }
    
    public function zero_fill($str, $len) {
    	for($i = strlen($str); $i < $len; $i++) {
    		$str = "0".$str;
    	}
    	return $str;
    }

}
