<?php
/**
 * aheadWorks Co.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://ecommerce.aheadworks.com/LICENSE-M1.txt
 *
 * @category   AW
 * @package    AW_Booking
 * @deprecated
 * @copyright  Copyright (c) 2009-2010 aheadWorks Co. (http://www.aheadworks.com)
 * @license    http://ecommerce.aheadworks.com/LICENSE-M1.txt
 */

class AW_Booking_Model_Checker extends AW_Core_Object{
	
	const ONE_DAY	= 86400;
	const ONE_HOUR	= 3600;
	const ONE_MINUTE = 60;
	
	const NO_PRICE = -1;

	public function _construct(){
		Zend_Date::setOptions(array('extend_month' => true));
		return parent::_construct();
	}

	protected function _checkProduct(){
		if(!$this->getProduct()){
			throw new AW_Core_Exception("Can't calculate for unsufficient product");
		}
	}

	public function getPriceForDate(Zend_Date $Date, $store_id=0){
		$this->_checkProduct();
		return $this->getPriceChecker()->getPriceForDate($this->getProduct()->getId(), $Date, $store_id);
	}
	
	public function getPriceForPeriod(Zend_Date $From, Zend_Date $To, $basePrice, $store_id=0, $failOnNoMultiplier = 0){
		$this->_checkProduct();
		return $this->getPriceChecker()->getPriceForPeriod($this->getProduct(), $From, $To, $basePrice, $store_id, $failOnNoMultiplier);
	}
	
	public function isDateAvail(Zend_Date $Date, $store_id=0){
		$this->_checkProduct();
		return $this->getDateChecker()->isDateAvail($this->getProduct(), $Date, $store_id=0);
	}
	
	/**
	 * Price checker object
	 * @return 
	 */
	public function getPriceChecker(){
		if(!$this->getData('price_checker')){
			$this->setData('price_checker', Mage::getSingleton('booking/checker_price'));
		}
		return $this->getData('price_checker');
	}
	
	/**
	 * Date checker object
	 * @return 
	 */
	public function getDateChecker(){
		if(!$this->getData('date_checker')){
			$this->setData('date_checker', Mage::getSingleton('booking/checker_date'));
		}
		return $this->getData('date_checker');
	}		
	/**
	 * Time checker object
	 * @return 
	 */
	public function getTimeChecker(){
		if(!$this->getData('time_checker')){
			$this->setData('time_checker', Mage::getSingleton('booking/checker_time'));
		}
		return $this->getData('time_checker');
	}		
}