<?php
/**
 * aheadWorks Co.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://ecommerce.aheadworks.com/LICENSE-M1.txt
 *
 * @category   AW
 * @package    AW_Booking
 * @copyright  Copyright (c) 2009-2010 aheadWorks Co. (http://www.aheadworks.com)
 * @license    http://ecommerce.aheadworks.com/LICENSE-M1.txt
 */

class AW_Booking_Helper_Yui extends Mage_Core_Helper_Abstract{

/*
 * Helper for YUI calendar.
 * 
 * */

	const DAY_FORMAT = 'n/j/Y';
	const MONTH_FORMAT = 'n/Y';
	

	public function formatDate($str=null){
		$time = $str ? strtotime($str) : time();
		return date(self::MONTH_FORMAT, $time);
	}

	public function formatDay($str=null){
		$time = $str ? strtotime($str) : time();
		return date(self::DAY_FORMAT, $time);
	}
	
	
	public function formatDayArray($range){
		// Formats array of timestamps to YUI calendar
		$out = array();
		foreach($range as $item){
			$out[] = date(self::DAY_FORMAT, $item);
		}
		return implode( ",", $out );
	}
	
	

}
