<?php
/**
 * aheadWorks Co.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://ecommerce.aheadworks.com/LICENSE-M1.txt
 *
 * @category   AW
 * @package    AW_Booking
 * @copyright  Copyright (c) 2009-2010 aheadWorks Co. (http://www.aheadworks.com)
 * @license    http://ecommerce.aheadworks.com/LICENSE-M1.txt
 */

class AW_Booking_Block_Catalog_Product_View_Timetable extends Mage_Core_Block_Template {
    
    protected $_product;
    protected $_date = false; 
    protected $_binds;


    /**
     * Retrieves current product
     * @return Mage_Catalog_Model_Product
     */
    public function getProduct(){
        if(!$this->_product) {
            if(Mage::registry('product')) {
                $this->_product = Mage::registry('product');
            }else {
                $this->_product = Mage::getSingleton('catalog/product')->load($this->getRequest()->getParam('id'));
            }
        }
        return $this->_product;
    }

    /**
     * Sets date
     * @param Zend_Date $date
     * @return AW_Booking_Block_Order_Hours
     */
    public function setDate(Zend_Date $date) {
        $this->_date = $date;
        return $this;
    }

    /**
     * Returns date
     * @return Zend_Date
     */
    public function getDate() {
        return $this->_date;
    }

    /**
     * Returns HTML with dates
     * @param Zend_Date $date
     * @return string
     */
    public function getFromToHtml(Zend_Date $date) {

        $hours = Mage::getModel('booking/checker_time')->getHoursRange($date, $this->getProduct());
        $hours = array_slice($hours, 0, -1);

        /*
         * Create hours titles block
         */
        $titles = $this->getHoursTitles();
        $out = '<table class="aw_booking_timetable">';
        $out .= '<thead><tr>';
        foreach($hours as $hour) {
            $out .= '<td colspan="2">'.$titles[$hour].'</td>';
        }
        $out .= '</tr></thead>';
        $out .= '<tbody><tr>';

        $i = 0;

        $To = clone $date;
        $From = clone $date;
        $From->setHour($hours[0])->setMinute(0)->setSecond(0);
        $To->setHour($hours[0])->setMinute(0)->setSecond(0);
        $To = $To->addMinute(30);
        
        
        
        $jsonTimeData = array();
        foreach($hours as $hour) {
        	
            $order_class = "common";

            list ($hour_from, $min_from, $sek) = explode(':', str_replace("01.01.1970 ", "", $From->getTime()));
            list ($hour_to, $min_to, $sek) = explode(':', str_replace("01.01.1970 ", "", $To->getTime()));
            $out .= '<td class="'.$order_class.'-prim ';
            if(!Mage::getModel('booking/checker_bind')->isQtyAvailableForPeriod($this->getProduct(), $From, $To)) {
                $out .= "busy\">";
                $timeData = array_fill(0,4,0);
            }else {
            	$timeData = array($hour_from, $min_from, $hour_to, $min_to);
                $out .= 'free hover-eff">';
            }
            $out.'</td>';
			array_push($jsonTimeData, $timeData);
            //if($i) {
                $From = $From->addMinute(30);
                $To = $To->addMinute(30);
            //}
			
            list ($hour_from, $min_from, $sek) = explode(':', str_replace("01.01.1970 ", "", $From->getTime()));
            list ($hour_to, $min_to, $sek) = explode(':', str_replace("01.01.1970 ", "", $To->getTime()));
            $out .= '<td class="'.$order_class.'-sec ';
            
            if(!Mage::getModel('booking/checker_bind')->isQtyAvailableForPeriod($this->getProduct(), $From, $To)) {
                $out .= "busy\">";
                $timeData = array_fill(0,4,0);
            }else {
            	$timeData = array($hour_from, $min_from, $hour_to, $min_to);
                $out .= 'free hover-eff">';
            }
            $out.'</td>';

            array_push($jsonTimeData, $timeData);

            $From = $From->addMinute(30);
            $To = $To->addMinute(30);

            $i+=1;
        }

        $out .= '</tr></tbody></table>';
        $out .= '<script type="text/javascript">Booking.timeslots='.Zend_Json::encode($jsonTimeData).';';
        $out .= 'Booking.RebindTimetable();</script>';
        return $out;
    }

 

    /**
     * Returns array with hours titles.
     * Used for formatting needs
     * @return array
     */
    public function getHoursTitles() {
        if (Mage::getSingleton('catalog/product_option_type_date')->is24hTimeFormat()) {
            // 24H format used 00-23
            return range(0,23);
        }else {
            // 12H format used
            return array(
                    '12 AM',
                    '1 AM',
                    '2 AM',
                    '3 AM',
                    '4 AM',
                    '5 AM',
                    '6 AM',
                    '7 AM',
                    '8 AM',
                    '9 AM',
                    '10 AM',
                    '11 AM',
                    '12 PM',
                    '1 PM',
                    '2 PM',
                    '3 PM',
                    '4 PM',
                    '5 PM',
                    '6 PM',
                    '7 PM',
                    '8 PM',
                    '9 PM',
                    '10 PM',
                    '11 PM'
            );
        }
    }
}
