<?php

class ESSO_Giveaways_Model_Observer
{
	public function __construct()
	{
		
	}
	
    /**
     * Retrieve shopping cart model object
     *
     * @return Mage_Checkout_Model_Cart
     */
    protected function _getCart()
    {
        return Mage::getSingleton('checkout/cart');
    }
	
    /**
     * Load Product by SKU Number
     *
     * @return Mage_Catalog_Model_Product || false
     */
    function loadProductBySKU($sku)
    {
        $product = Mage::getModel('catalog/product')
        	->setStoreId(Mage::app()->getStore()->getId())
            ->loadByAttribute("sku", $sku);
        if ($product)
        	$product = Mage::getModel('catalog/product')
        	->setStoreId(Mage::app()->getStore()->getId())
            ->load($product->getId()); 
        return $product;
    }
    
	/**
	* 
	* @param   Varien_Event_Observer $observer
	*/
	public function post_add($observer)
	{
		if (Mage::getStoreConfig('esso/giveaways/enabled'))
		{
			$cart   = $this->_getCart();
			$sku = Mage::getStoreConfig( "esso/giveaways/product_sku");
			if ($sku) {
		    	$moa_product = $this->loadProductBySKU($sku);
		        // add default product if not allready in Cart
		        if ($moa_product && !in_array($moa_product->getId(), $cart->getProductIds())) {
		        	$cart->addProduct($moa_product);
		        	$cart->save();	
		        }
	        }
			return $this;
		}
	}

}
