<?php
/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@magentocommerce.com so we can send you a copy immediately.
 *
 * @category   Unic
 * @package    Unic_SaferpayNew
 * @copyright  Copyright (c) 2004-2008 Unic Internet Solutions (http://www.unic.com)
 * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

/**
 * SaferpayNew Model SaferpayNew
 *
 * @category   Unic
 * @package    Unic_SaferpayNew
 * @name       Unic_SaferpayNew_Model_SaferpayNew
 * @author     Unic Internet Solutions <magento@unic.com>
 */

class Unic_SaferpayNew_Model_SaferpayNew extends Mage_Payment_Model_Method_Abstract {
	protected $_code = 'saferpaynew';
	protected $_isGateway = true;
	protected $_canAuthorize = false;
	protected $_canCapture = true;
	protected $_canCapturePartial = false;
	protected $_canRefund = false;
	protected $_canVoid = false;
	protected $_canUseInternal = false;
	protected $_canUseCheckout = true;
	protected $_canUseForMultishipping = false;
	protected $_formBlockType = 'saferpaynew/form';
	protected $_paymentMethod = 'saferpaynew';
	protected $_order;
	
	/**
	 * Get order model
	 *
	 * @return Mage_Sales_Model_Order
	 */
	public function getOrder() {
		if (! $this->_order) {
			$paymentInfo = $this->getInfoInstance ();
			$this->_order = Mage::getModel ( 'sales/order' )->loadByIncrementId ( $paymentInfo->getOrder ()->getRealOrderId () );
		}
		return $this->_order;
	}
	
	/**
	 * Get Customer Id
	 *
	 * @return string
	 */
	public function getCustomerId() {
		return Mage::getStoreConfig ( 'payment/' . $this->getCode () . '/customer_id' );
	}
	
	/**
	 * Get currency that is accepted by SaferpayNew account
	 *
	 * @return string
	 */
	public function getAcceptedCurrency() {
		return Mage::getStoreConfig ( 'payment/' . $this->getCode () . '/currency' );
	}
	
	/**
	 * test wheter the current currency is within the available currencies or not
	 *
	 * @return unknown
	 */
	public function validate() {
		parent::validate ();
		$paymentInfo = $this->getInfoInstance ();
		
		return $this;
	}
	
	/**
	 * This is the function that gets called if button "Place Order" is pressed
	 * in the checkout process.
	 *
	 * @return the URL to be redirected to
	 */
	public function getOrderPlaceRedirectUrl() {
	    
		return Mage::getUrl ( 'saferpaynew/saferpaynew/redirect' );
	}
	
	/**
	 * prepare the arguments that have to be passed to the command line tool
	 *
	 * @return array containing the elements
	 */
	public function getSaferpayNewUrl() {
		$fieldsArr = array ( );
		$paymentInfo = $this->getInfoInstance ();
		$fieldsArr ['AMOUNT'] = ($this->getOrder ()->getTotalDue() * 100);
		$fieldsArr ['CURRENCY'] = '"'.$this->getOrder()->getOrderCurrencyCode().'"';
		$fieldsArr ['DESCRIPTION'] = '"' . urlencode(Mage::getStoreConfig ( 'payment/saferpaynew/description' )) . '"';
		
        $fieldsArr ['ALLOWCOLLECT'] = '"no"';
		$fieldsArr ['DELIVERY'] = '"no"';
		
		$fieldsArr ['ACCOUNTID'] = '"'.Mage::helper ( 'core' )->decrypt ( Mage::getStoreConfig ( 'payment/saferpaynew/account_id' ) ).'"';
		$fieldsArr ['SUCCESSLINK'] = '"'.Mage::getUrl ( 'saferpaynew/saferpaynew/success' ).'"';
		$fieldsArr ['NOTIFYURL'] = '"'.Mage::getUrl ( 'saferpaynew/saferpaynew/notify' ).'"';
		$fieldsArr ['BACKLINK'] = '"'.Mage::getUrl ( 'saferpaynew/saferpaynew/cancel' ).'"';
		$fieldsArr ['FAILLINK'] = '"'.Mage::getUrl ( 'saferpaynew/saferpaynew/failure' ).'"';
		$fieldsArr ['AUTOCLOSE'] = 5;
		
		if (Mage::getStoreConfig ( 'payment/saferpaynew/notifyemail') != '') {
		    $fieldsArr ['NOTIFYADDRESS'] = '"' .Mage::getStoreConfig ( 'payment/saferpaynew/notifyemail') .'"';
		}
		
		$fieldsArr ['ORDERID'] = $paymentInfo->getOrder ()->getRealOrderId ();
		
		/*
		 * build a xml-like form of the attributes that get stored in
		 * saferpay_api_debug table
		 */
		$request = '';
		foreach ( $fieldsArr as $k => $v ) {
			$request .= '<' . $k . '>' . $v . '</' . $k . '>';
		}
		
		if ($this->getDebug ()) {
			$debug = Mage::getModel ( 'saferpaynew/api_debug' )->setRequestBody ( $request )->setOrderId ( $fieldsArr ['ORDERID'] )->save ();
			$fieldsArr ['saferpayOption1'] = $debug->getId ();
		}
		
/*	    $parameters = '';
        foreach ( $fieldsArr as $field => $value ) {
            $parameters .= ' -a ' . $field . ' ' . $value;
        }
        
        $command = Mage::getStoreConfig ( 'payment/saferpaynew/spexec_path' ).' -payinit -p '.Mage::getStoreConfig ( 'payment/saferpaynew/spconf_path' ).$parameters;
        $command = escapeshellcmd($command);
        
        $url =  shell_exec(escapeshellcmd($command));
*/

      $parameters = '';
      foreach ( $fieldsArr as $field => $value ) {
          $parameters .= '&' . $field . '=' . $value;
      }
      $request_url =  "https://www.saferpay.com/hosting/CreatePayInit.asp?".substr($parameters, 1);
      
      # HTTPS:Request aufbauen und Ergebnis abfragen
      $ch = curl_init();
      curl_setopt($ch, CURLOPT_VERBOSE, TRUE);    
      curl_setopt($ch, CURLOPT_URL, $request_url);
      curl_setopt($ch, CURLOPT_PORT, 443);
      curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	    //curl_setopt($ch, CURLOPT_POST, true);
     	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	    curl_setopt($ch, CURLOPT_HEADER, false);
	    $url = curl_exec($ch);
	    curl_close($ch);
  		return $url;
	}
	
	/**
	 * Get debug flag
	 *
	 * @return string
	 */
	public function getDebug() {
		return Mage::getStoreConfig ( 'payment/' . $this->getCode () . '/debug_flag' );
	}
	
	/**
	 * Return redirect block type
	 *
	 * @return string
	 */
	public function getRedirectBlockType() {
		return $this->_redirectBlockType;
	}
	
	public function getFormBlockType() {
	    return $this->_formBlockType;
	}
	
	/**
	 * Return payment method type string
	 *
	 * @return string
	 */
	public function getPaymentMethodType() {
		return $this->_paymentMethod;
	}
}
