<?php

class FandM_MandatoryItems_Model_Observer extends Mage_Core_Controller_Front_Action
{
	public function __construct()
	{
		
	}
	
    /**
     * Retrieve shopping cart model object
     *
     * @return Mage_Checkout_Model_Cart
     */
    protected function _getCart()
    {
        return Mage::getSingleton('checkout/cart');
    }
	
    /**
     * Load Product by SKU Number
     *
     * @return Mage_Catalog_Model_Product || false
     */
    function loadProductBySKU($sku)
    {
        $product = Mage::getModel('catalog/product')
        	->setStoreId(Mage::app()->getStore()->getId())
            ->loadByAttribute("sku", $sku);
        if ($product) {
        	$product = Mage::getModel('catalog/product')
        	->setStoreId(Mage::app()->getStore()->getId())
            ->load($product->getId()); 
        } else {
    	    print "product cannot be loaded";
    	    exit;
        }
        return $product;
    }
    
    /**
     * Load Product by ID Number
     *
     * @return Mage_Catalog_Model_Product || false
     */
    function loadProductByID($id)
    {
        return $product = Mage::getModel('catalog/product')
        	->setStoreId(Mage::app()->getStore()->getId())
            ->load($id); 
    }
    
    /**
     * Get Product if Configured
     *
     * @return Mage_Catalog_Model_Product || false
     */
    public function load_mandatory_product($num) {
    	return $this->loadProductBySKU(
			Mage::getStoreConfig("fandm/mandatoryitems/sku".$num));
    }
    
    public function check_condition($num) {
    	$to_add = false;
    	$cart   = $this->_getCart();
    	foreach($cart->getProductIds() as $id) {
			$product = $this->loadProductByID($id);
			$atr_name = Mage::getStoreConfig( "fandm/mandatoryitems/atr_name".$num);
			$value = $product->getData($atr_name);
			if ($value != "" && (string)$value == Mage::getStoreConfig("fandm/mandatoryitems/atr_value".$num)) {
				$to_add = true;
			}
				
		}
		return $to_add;
    }
    
    public function tryRemoveProduct($product){
    	$cart = $this->_getCart();
    	if (in_array($product->getId(), $cart->getProductIds())) {
    		$item_id = false;
    		foreach($cart->getItems() as $item) {
    			if ($item->getProduct()->getId() == $product->getId()) {
    				$item_id = $item->getId(); 
    			}
    		}
    		if ($item_id)
    			$cart->removeItem($item_id)->save();
    	}
    }
    
    public function product_in_items($product_id) {
    	foreach ($this->_getCart()->getItems() as $item) {
    		if ($item->getProduct()->getId() == $product_id)
    			return true;
    	}
    	return false;
    }
    
	/**
	* 
	* @param   Varien_Event_Observer $observer
	*/
	public function add_mandatory_item($observer)
	{
		if (Mage::getStoreConfig('fandm/mandatoryitems/enabled'))
		{
			$cart   = $this->_getCart();
			$cart->init();
			$default_sku = Mage::getStoreConfig( "fandm/mandatoryitems/default_sku");
			$dafault_product = $this->loadProductBySKU($default_sku);
			$mandatory_product1 = $this->load_mandatory_product(1);
			if ($this->check_condition(1)) {
				if (!($this->product_in_items($mandatory_product1->getId()))) {	
					$cart->addProduct($mandatory_product1);
		        	$cart->save();
		        }
		     	if ($dafault_product)
					$this->tryRemoveProduct($dafault_product);
			} elseif ($dafault_product) {
				if (!($this->product_in_items($dafault_product->getId()))){		
					$cart->addProduct($dafault_product);
		        	$cart->save();
		        }
		        if ($mandatory_product1)
					$this->tryRemoveProduct($mandatory_product1);
	        }
	        // empty cart if this is last product ...
	        if (sizeof($cart->getProductIds()) == 1) {
	        	foreach($cart->getItems() as $item)
	        		$cart->removeItem($item->getId());
	        	$cart->save();
	        }
	        return $this;
		}
	}
	
	/**
	* 
	* @param   Varien_Event_Observer $observer
	*/
	public function pre_delete($observer) {
		if (Mage::getStoreConfig('fandm/mandatoryitems/enabled'))
		{
			$cart   = $this->_getCart();
			$default_sku = Mage::getStoreConfig( "fandm/mandatoryitems/default_sku");
			$dafault_product = $this->loadProductBySKU($default_sku);
			$mandatory_product1 = $this->load_mandatory_product(1);
			//var_dump($observer);
			$controller = $observer->getData("controller_action");
			$item_id = $controller->getRequest()->getParam('id');
			foreach($cart->getItems() as $item) {
				if ($item->getId() == $item_id) {
					$prod_id = $item->getProduct()->getId();
					if (($dafault_product && $dafault_product->getId() == $prod_id) || 
						($mandatory_product1 && $mandatory_product1->getId() == $prod_id)) {						
						Mage::getSingleton('checkout/session')->addError(
							Mage::helper('checkout')->__("Cannot remove the item."));
						$controller->updatePostAction();
						$controller->setFlag('', Mage_Core_Controller_Varien_Action::FLAG_NO_DISPATCH, true);
					}	
				}
			}
		}
	}

}
