<?php
/**
 * aheadWorks Co.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://ecommerce.aheadworks.com/LICENSE-M1.txt
 *
 * @category   AW
 * @package    AW_Booking
 * @deprecated
 * @copyright  Copyright (c) 2009-2010 aheadWorks Co. (http://www.aheadworks.com)
 * @license    http://ecommerce.aheadworks.com/LICENSE-M1.txt
 */

class AW_Booking_Model_Checker_Bind extends AW_Core_Object {

	private $_linked = array();
	private $_qtyLeft = array();
	
    public function _construct() {
	Zend_Date::setOptions(array('extend_month' => true));
	return parent::_construct();
    }

    /**
     * Check if date can be binded
     * @param Zend_Date $Date
     * @param object    $product_id
     * @param object    $qty [optional]
     * @return bool
     */
    public function isQtyAvailable($product_id, Zend_Date $Date, $qty=1, $includeCart=true) {
		return $this->isQtyAvailableForDate($product_id, $Date, $qty, $includeCart);
    }

    /**
     * Alias for $this->isQtyAvailable
     * @param <type> $product_id
     * @param Zend_Date $Date
     * @param <type> $qty
     * @param bool $includeCart
     */
    public function isQtyAvailableForDate($product_id, Zend_Date $Date, $qty=1, $includeCart=true) {

	$_date = clone $Date;

	$model = Mage::getModel('catalog/product');
	if($product_id instanceof $model) {
	    $Product = $product_id;
	} else {
	    $Product = $model->load($product_id);
	}
	
	// check if master quantity should be returned instead of own
	$master_product_id = (int) $Product->getAwMasterQuantityProductId();

	if ($master_product_id > 0) {
		return $this->isQtyAvailableForDate($master_product_id, $_date, $qty, $includeCart);
	} else {
		$proId = $Product->getId();
	}
	$total_binds = $this->getTotalBinds($proId, $_date, $includeCart);
	
	// Verfügbare Stückzahl zwischenspeichern
	$this->_qtyLeft[$Date->toString()] = $Product->getAwBookingQuantity() - $total_binds;

	return $total_binds <= ($Product->getAwBookingQuantity() - $qty);
    }

	private function getTotalBinds($product_id, $_date, $includeCart) {
		$model = Mage::getModel('catalog/product');
		$Product = $model->load($product_id);
		
		if($includeCart && $Quote = Mage::helper('checkout')->getQuote()){
			$quoteId = $Quote->getId();
		} else {
			$quoteId = 0;
		}
	
		$ids = $this->getLinkedProductIds($product_id);
		array_push($ids, $product_id);
		
		$Orders = Mage::getModel('booking/order')
			->getCollection()
			->addQuoteIdFilter($quoteId)
			->addProductIdsFilter($ids);
	
		if($Product->getAwBookingQratioMultiplier() == AW_Booking_Model_Entity_Attribute_Source_Qratiomultipliertype::HOURS) {
			$Orders->addBindDateTimeFilter($_date);
		} else {
			$Orders->addBindDateFilter($_date);
		}
	
		$total_binds = $Orders->count();
		return $total_binds;
	}
	/**
	 * Return all product ids associated with the passed product id
	 * @param integer $productId
	 * @return array
	 */
	private function getLinkedProductIds($productId) {
		if (isset($this->_linked[$productId])) {
			return $this->_linked[$productId];
		}

		$resource = Mage::getSingleton('core/resource');
		$read = $resource->getConnection('catalog_read');
		$productEntityVarcharTable = (string)Mage::getConfig()->getTablePrefix() . 'catalog_product_entity_varchar';
		$eavAttributeTable = $resource->getTableName('eav/attribute');
		$categoryProductTable = $resource->getTableName('catalog/category_product');
		$select = "
		  SELECT DISTINCT 
			ccp.product_id
		  FROM
			$productEntityVarcharTable cpev
		  INNER JOIN $categoryProductTable ccp ON (cpev.entity_id = ccp.product_id),
			$eavAttributeTable ea
		  WHERE
			cpev.attribute_id = ea.attribute_id AND 
			ea.attribute_code = 'aw_master_quantity_product_id' AND
			cpev.value = '$productId'";

		$res = $read->fetchAll($select, array(), Zend_Db::FETCH_COLUMN);
		//cache result
		$this->_linked[$productId] = $res; 
		return $res;
	}
    /**
     * Check if period if specified quantity is available for period
     * @param object    $product_id
     * @param Zend_Date $From
     * @param Zend_Date $To
     * @param object    $qty [optional]
     * @return bool
     */
    public function isQtyAvailableForPeriod($product_id, Zend_Date $_From, Zend_Date $_To, $qty=1, $includeCart=true) {

	$From = clone $_From;
	$To = clone $_To;

	$model = Mage::getModel('catalog/product');
	if($product_id instanceof $model) {
	    $Product = $product_id;
	}else {
	    $Product = $model->load($product_id);
	}

	if($Product->getAwBookingQratioMultiplier() == AW_Booking_Model_Entity_Attribute_Source_Qratiomultipliertype::HOURS) {
	    $method = 'addHour';
	}else {
	    $method = 'addDayOfYear';
	}

	while($From->compare($To) <= 0) {
	    if(!$this->isQtyAvailable($Product, $From,  $qty, $includeCart)) {
		return false;
	    }
	    $From = call_user_func(array($From, $method), 1);
	}
	return true;
    }
    /**
     * Return the available quantity within the specified period
     * @param object    $product_id
     * @param Zend_Date $From
     * @param Zend_Date $To
     * @param object    $qty [optional]
     * @return integer
     */
	public function getAvailableQtyForPeriod($product_id, Zend_Date $_From, Zend_Date $_To, $qty=1, $includeCart=true) {
		if (count($this->_qtyLeft) == 0) {
			$this->isQtyAvailableForPeriod($product_id, $_From, $_To, $qty, $includeCart);
		}
		return array_sum($this->_qtyLeft);
	}
    /**
     * Return unavailable dates as array
     * @param <type> $product_id
     * @param Zend_Date $_From
     * @param Zend_Date $_To
     * @param <type> $qty
     * @return array
     */
    public function getUnavailDays($Product, Zend_Date $_From, Zend_Date $_To, $qty=1, $includeCart=true) {
	$dates = array();
	// Clone from and to to not affect original values
	$From = clone $_From;
	$To = clone $_To;
	while($From->compare($To) <= 0) {
	    $dates[$From->toString(AW_Core_Model_Abstract::DB_DATE_FORMAT)] = $this->isQtyAvailable($Product, $From,  $qty, $includeCart);
	    $From = $From->addDayOfYear(1);
	}
	
	return $dates;
    }
}