<?php
class AW_Scheduler_Model_Order_Observer extends Mage_Core_Model_Abstract{
	
	
	/**
	 * @param Mage_Cron_Model_Schedule $schedule
	 */
	public function cancelOldOrders($schedule) {
		if (Mage::getStoreConfig('scheduler/order_observer/enabled')) {
			$time_offset = Mage::getStoreConfig('scheduler/order_observer/time_offset');
			$time_to = new Zend_Date();
    		$time_to->addMinute(-$time_offset);
    		$time_from = new Zend_Date();
    		$time_from->addMinute(-2880 - $time_offset);
			
			/* @var $collection AW_Booking_Model_Mysql4_Order_Collection */
			$collection = Mage::getModel('booking/order')->getCollection();
			$collection->addTimeRangeFilter($time_from->toString("Y-MM-dd HH:mm:ss"), $time_to->toString("Y-MM-dd HH:mm:ss"));
			foreach($collection as $aw_order) {
				/* @var $aw_order AW_Booking_Model_Order */
				/* @var $sales_order Mage_Sales_Model_Order */
				$sales_order = Mage::getModel("sales/order"); 
				$sales_order->loadByIncrementId($aw_order->getOrderId());
				if (!$sales_order->hasInvoices()) {
					// no Invoices -> cancel AW_Booking Orders and sales_order!
					$aw_order->setIsCanceled(1);
					$aw_order->save();
					
					if (!$sales_order->isCanceled()) {
						$sales_order->cancel();
						$sales_order->addStatusHistoryComment("Bestellung wurde abgebrochen wegen Zeitübersreitung bei Saferpay Bestättigung.", Mage_Sales_Model_Order::STATE_CANCELED);
						$sales_order->save();
					}
				}
			}
		}	
	}
	
}