<?php
/**
 * aheadWorks Co.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://ecommerce.aheadworks.com/LICENSE-M1.txt
 *
 * @category   AW
 * @package    AW_Core
 * @version    1.0
 * @copyright  Copyright (c) 2009-2010 aheadWorks Co. (http://www.aheadworks.com)
 * @license    http://ecommerce.aheadworks.com/LICENSE-M1.txt
 */

class AW_Core_Model_Abstract extends Mage_Core_Model_Abstract {
    /**
     * Logs entry wrapper
     * @param object $message
     * @param object $severity [optional]
     * @return
     */

    const DB_DATETIME_FORMAT = 'yyyy-MM-dd HH:m:s'; // DON'T use Y(uppercase here)
    const DB_DATE_FORMAT= 'yyyy-MM-dd';
    const JS_DATE_FORMAT= 'yyyy-M-d';

    const RETURN_BOOLEAN = 'BOOL';
    const RETURN_INTEGER = 'INT';
    const RETURN_FLOAT = 'FLOAT';
    const RETURN_STRING = 'STR';
    const RETURN_ARRAY = 'ARR';
    const RETURN_OBJECT = 'OBJ';

    public function log($message, $severity=null, $details='') {
	Mage::helper('awcore/logger')->log($this, $message, $severity, $details);
    }
}